% main_postestimation_counterfactuals.m
% 
% runs likelihood-measure based counterfactuals
% 
% Estimating Macroeconomic Models of Financial Crises: An Endogenous Regime-Switching Approach*
%   Gianluca Benigno, Andrew Foerster, Christopher Otrok, Alessandro Rebucci
% 
% Updated July 2024
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %


% -- Clear Workspace -- %
clc;
clear;
close all;

% -- Options -- %est
addpath('../Solver - SV')
addpath(genpath('../Utilities'));
GLOBALS = globals();

% - Data -- %
y       = GLOBALS.y;
dates   = GLOBALS.dates;
rrdates = GLOBALS.rrdates;
D       = GLOBALS.estimation.D;


%% -- CALCULATE LIKELIHOOD BASED MEASURE -- %%
% -- Setup -- %
qm = getparams(GLOBALS);
kf_filtering_level = 1;
NX      = GLOBALS.estimation.NX;
NY      = GLOBALS.estimation.NY;
table   = zeros(GLOBALS.ne,length(y));
ne      = GLOBALS.ne;


for tt = 1:length(y)
    disp(tt)    
    
    for ee = 1:ne
        
        % -- Get Estimates -- %
        [Posterior, Counter] = endo_ms_lik_2nd_kim_nelson_SV_counter(qm,y,kf_filtering_level,1,0,GLOBALS,tt,ee);

        table(ee,tt) = max(Posterior - Counter, 1e-4); % max for numerical error
        
    end
end



    
%% -- Figure 6: Historical Importance of Shocks -- %%
tablenormed = table./sum(table);
maxes       = [0.8 0.4 0.3 0.4 0.5 0.4];

figure(6)
for ii = 1:GLOBALS.ne
    subplot(GLOBALS.ne,1,ii)
    hold on;
    bar(dates,rrdates>0,1.02,'FaceColor',[0.75 0.75 0.75],'EdgeColor','none','ShowBaseLine','off');
    yyaxis left
    plot(dates,tablenormed(ii,:),'-k','LineWidth',2)
    ylim([0 maxes(ii)])
    yticks(0:0.1:1)
    yyaxis right
    plot(dates,ones(size(dates))*mean(tablenormed(ii,:)),'--k')
    ylim([0 maxes(ii)])
    set(gca,{'ycolor'},{'k'})
    yticks(0:0.1:1)
    xticks(dates(1:4:end))
    datetick('x',17,'keepticks');    
    ax = gca;
    labels = string(ax.XAxis.TickLabels);
    labels(1:5:end) = nan; 
    labels(2:5:end) = nan; 
    labels(3:5:end) = nan; 
    labels(4:5:end) = nan; 
    ax.XAxis.TickLabels = labels;   
    xtickangle(0)
    set(gca, 'Layer','top')
    box on
    title(GLOBALS.shocklist{ii,2})
end
print('-dpdf', '..\Figures and Tables\Figure_6.pdf', '-fillpage')


